'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Abbruch_Click()
On Error GoTo Err_Button_Abbruch_Click


    DoCmd.Close

Exit_Button_Abbruch_Click:
    Exit Sub

Err_Button_Abbruch_Click:
    MsgBox err.Description
    Resume Exit_Button_Abbruch_Click
    
End Sub

Private Sub Button_OK_Click()

    'Variablen deklarieren
    Dim dbs As Database, rst As Recordset
    Dim FilterGebuehr As String
    
    'Gltigkeitsprfungen
    If (IsNull(Me.gilt_ab.Value) Or (Trim(Me.gilt_ab.Value) = "")) Then
        MsgBox "Bitte geben Sie ein Gilt-ab-Datum ein!", vbCritical, "Fehler"
        Me.gilt_ab.SetFocus
        Exit Sub
    End If
    If (IsNull(Me.Stundensatz.Value) Or (Trim(Me.Stundensatz.Value) = "")) Then
        MsgBox "Bitte geben Sie einen Preis ein!", vbCritical, "Fehler"
        Me.Stundensatz.SetFocus
        Exit Sub
    End If
            
    'Hinweis zum Warten anzeigen
    'DoCmd.OpenForm "Bitte_warten"
    'Forms![Bitte_warten].Repaint
    
    'Filterzeichenkette vorbereiten
    FilterGebuehr = "SELECT * FROM Km_Preise WHERE [gilt_ab] = #"
    FilterGebuehr = FilterGebuehr & Month(Me.gilt_ab.Value) & "/" & Day(Me.gilt_ab.Value) & "/" & Year(Me.gilt_ab.Value) & "#"
    
    'Tabelle ffnen und nachsehen, ob Datum bereis vorhanden ist
    On Error GoTo ErrorGebuehrAnlegenFehler
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset(FilterGebuehr)
    If (rst.RecordCount) = 0 Then
        'Gebhr anlegen
        rst.AddNew
        rst!gilt_ab = Me.gilt_ab.Value
        rst!Preis = Me.Stundensatz.Value
        rst!Jahr = Year(Me.gilt_ab.Value)
        rst!Monat = Month(Me.gilt_ab.Value)
        rst!Tag = Day(Me.gilt_ab.Value)
        rst.Update
        rst.Close
    Else
        'Hinweis zum Warten schlieen
        'DoCmd.Close acForm, "Bitte_warten", acSaveYes
        'Forms![Bitte_warten].Repaint
        
        'wenn Datum bereits vorhanden
        MsgBox "Das Gilt-ab-Datum ist bereits vorhanden! Bitte geben Sie ein anderes Datum ein.", vbCritical, "Fehler"
        Me.gilt_ab.SetFocus
        Exit Sub
    End If
    
    
ExitGebuehrAnlegen:

    Set rst = Nothing
    Set dbs = Nothing
    
    'Aufrufendes Formular zwecks Aktualisierung schlieen und wieder ffnen
    'DoCmd.Close acForm, FormularName, acSaveYes
    'DoCmd.OpenForm FormularName, , , , , , AktKunde
    'Anzeige aktualisieren
    If FormularName = "Einstellungen_2" Then Forms![Einstellungen_2].[km_Preisliste].Form.Requery
    'sich selbst schlieen
    DoCmd.Close acForm, "km_Preis_neu", acSaveYes
    
    Exit Sub
    
    
ErrorGebuehrAnlegenFehler:
        MsgBox "Beim Speichern des Preises trat ein Fehler auf!", vbCritical, "Fehler"
        MsgBox err.Description
        Resume ExitGebuehrAnlegen

End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Whrungsformat des Systems einstellen
    Me.Stundensatz.Format = "Currency"
    
    Me.gilt_ab.InputMask = "00/00/0099;0;_"
End Sub

Private Sub Stundensatz_Exit(Cancel As Integer)
    If (IsNull(Me.Stundensatz.Value) Or (Trim(Me.Stundensatz.Value) = "")) Then Exit Sub
    Me.Stundensatz.Value = Format(Me.Stundensatz.Value, "#,##0.0000")
End Sub
